/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.interpreter.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.core.interpreter.IInterpreter;
import com.aptana.php.debug.core.util.FileUtils;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.PHPINIUtil;

public class PHPexeItem
implements IInterpreter {
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String DYLD_LIBRARY_PATH = "DYLD_LIBRARY_PATH";
    public static final String SAPI_CLI = "CLI";
    public static final String SAPI_CGI = "CGI";
    private static final Pattern PHP_VERSION = Pattern.compile("PHP (\\d\\.\\d\\.\\d+).*? \\((.*?)\\)");
    private static final Pattern PHP_CLI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path => (.*?)");
    private static final Pattern PHP_CGI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path </td><td class=\"v\">(.*?)</td>");
    private String sapiType;
    private String name;
    private File config;
    private File detectedConfig;
    private File executable;
    private String version;
    private boolean editable = true;
    private String debuggerID;
    private boolean isDefault;
    private HashSet<String> extensions = new HashSet();

    public PHPexeItem(String name, String executable, String config, String debuggerID) {
        this.name = name;
        this.debuggerID = debuggerID;
        this.executable = new File(executable);
        if (!StringUtil.isEmpty((String)config)) {
            this.config = new File(config);
        }
        this.detectFromPHPExe();
    }

    public PHPexeItem(String name, File executable, File iniLocation, String debuggerID, boolean editable) {
        this.name = name;
        this.executable = executable;
        this.config = iniLocation;
        this.debuggerID = debuggerID;
        this.editable = editable;
        try {
            this.detectFromPHPExe();
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError(e.getMessage(), e);
        }
    }

    public PHPexeItem() {
    }

    public String[] getExtensions() {
        return this.extensions.toArray(new String[this.extensions.size()]);
    }

    public void setExtensions(String[] extensions) {
        HashSet<String> exts = new HashSet<String>();
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            exts.add(s);
            ++n2;
        }
        this.extensions = exts;
    }

    public String getDebuggerID() {
        return this.debuggerID;
    }

    public void setDebuggerID(String debuggerID) {
        this.debuggerID = debuggerID;
    }

    public File getINILocation() {
        return this.config;
    }

    public File getDetectedINILocation() {
        return this.detectedConfig;
    }

    public void setINILocation(File location) {
        this.config = location;
    }

    public String getSapiType() {
        return this.sapiType;
    }

    public void setSapiType(String sapiType) {
        this.sapiType = sapiType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getExecutable() {
        return this.executable;
    }

    public void setExecutable(File executable) {
        if (executable == null) {
            throw new IllegalArgumentException("PHP executable path is null");
        }
        if (executable.equals(this.executable)) {
            return;
        }
        this.executable = executable;
        this.config = null;
        this.detectFromPHPExe();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHPexeItem other = (PHPexeItem)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name);
        buf.append(" [path: ").append(this.executable != null ? this.executable.getAbsolutePath() : "<unknown>");
        buf.append(", config file: ").append(this.config.getAbsolutePath());
        buf.append(", sapi: ").append(this.sapiType);
        buf.append("]");
        return buf.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    protected void detectFromPHPExe() {
        Matcher m;
        if (this.executable == null) {
            throw new IllegalStateException("PHP executable path is null");
        }
        File tempPHPIni = PHPINIUtil.createTemporaryPHPINIFile();
        PHPexeItem.changePermissions(this.executable);
        Map<String, String> environment = new ProcessBuilder(new String[0]).environment();
        if ("macosx".equals(Platform.getOS())) {
            environment.put(DYLD_LIBRARY_PATH, this.executable.getParent());
        } else if (!"win32".equals(Platform.getOS())) {
            environment.put(LD_LIBRARY_PATH, this.executable.getParent());
        }
        String output = ProcessUtil.outputForCommand((String)this.executable.getAbsolutePath(), (IPath)Path.fromOSString((String)this.executable.getParent()), environment, (String[])new String[]{"-c", tempPHPIni.getParentFile().getAbsolutePath(), "-v"});
        if (PHPDebugEPLPlugin.getDefault().isDebugging() || PHPDebugEPLPlugin.DEBUG) {
            IdeLog.logInfo((Plugin)PHPDebugEPLPlugin.getDefault(), (String)output);
        }
        if ((m = PHP_VERSION.matcher(output)).find()) {
            this.version = m.group(1);
            String type = m.group(2);
            if (type.startsWith("cgi")) {
                this.sapiType = SAPI_CGI;
            } else if (type.startsWith("cli")) {
                this.sapiType = SAPI_CLI;
            } else {
                PHPDebugEPLPlugin.logWarning("Can't determine type of the PHP executable");
                this.executable = null;
                return;
            }
            if (this.name == null) {
                this.name = "PHP " + this.version + " (" + this.sapiType + ")";
            }
        } else {
            PHPDebugEPLPlugin.logWarning("Can't determine version of the PHP Interpreter");
            this.executable = null;
            return;
        }
        if (this.detectedConfig == null) {
            output = ProcessUtil.outputForCommand((String)this.executable.getAbsolutePath(), (IPath)Path.fromOSString((String)this.executable.getParent()), environment, (String[])new String[]{"-c", tempPHPIni.getParentFile().getAbsolutePath(), "-i"});
            if (this.sapiType == SAPI_CLI) {
                m = PHP_CLI_CONFIG.matcher(output);
            } else if (this.sapiType == SAPI_CGI) {
                m = PHP_CGI_CONFIG.matcher(output);
            }
            if (m.find()) {
                String configDir = m.group(1);
                this.detectedConfig = new File(configDir.trim(), "php.ini");
                if (!this.detectedConfig.exists()) {
                    this.detectedConfig = null;
                }
            } else {
                PHPDebugEPLPlugin.logWarning("Can't determine PHP.ini location of the PHP Interpreter");
                this.executable = null;
                return;
            }
        }
    }

    public static String getLibVarriable(File executable) {
        StringBuilder buf = new StringBuilder();
        String os = Platform.getOS();
        if (!"win32".equals(os)) {
            boolean isMac = "macosx".equals(os);
            if (isMac) {
                buf.append(DYLD_LIBRARY_PATH);
            } else {
                buf.append(LD_LIBRARY_PATH);
            }
            buf.append('=');
            buf.append(executable.getParent());
        }
        return buf.toString();
    }

    public static void changePermissions(File file) {
        FileUtils.setExecutablePermissions((File)file);
    }
}

